﻿using Astera.Core;
using Astera.RulesEngine;
using Astera.ServerManager;
using Astera.Transfer;
using Astera.Transfer.Dataflow;
using Astera.Transfer.Server;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CarConvert {
    class Program {
        static void Main(string[] args) {

            // pass in arguments for input cprj and output car file paths
            string projectFilePath = args[0];
            string archiveFileName = args[1];

            Console.WriteLine("Building: " + projectFilePath);
            Console.WriteLine("Archive: " + archiveFileName);

            try
            {
                InitalizeAPI();

                // build the centerprise archive
                var logFile = CenterpriseArchive.Build(projectFilePath, archiveFileName);

                // log the result
                string message;
                if (logFile != null)
                    message = string.Format("Archive build completed with errors/warnings. Log was written to {0}", logFile);
                else
                    message = "Archive build completed successfully.";
                Console.WriteLine(message);

            }
            catch (Exception ex) {
                Console.WriteLine(ex);
            }

        }

        private static void InitalizeAPI()
        {
            // archive builder initialization                
            AsteraAppContext.ProductType = ProductType.ClientFull;
            AsteraAppContext.Functions = new FunctionManager();
            AsteraAppContext.DbProviders = DbProviderManager.Create(AsteraAppContext.ProductType);
            AsteraAppContext.FSProviders = new Astera.Transfer.Workflow.FSProviderManager();
            AsteraAppContext.DataModelCache = new QueryDataModelCache();
            AsteraAppContext.ArchiveCache = new CenterpriseArchiveCache();
            AsteraAppContext.Client.JobStarter = new JobStarter();
            ItemDataManager.Instance.AddAssembly(typeof(DataflowItemDataBase).Assembly);
            ItemDataManager.Instance.Load();
            FrameworkInitializer initializer = new FrameworkInitializer();
            initializer.Initialize();
        }
    }
}
